
<?php $__env->startSection('title','Unit Customer'); ?>
<?php $__env->startSection('content'); ?>
        
        <div class="breadcrumbs">
            <div class="breadcrumbs-inner">
                <div class="row m-0">
                    <div class="col-sm-4">
                        <div class="page-header float-left">
                            <div class="page-title">
                                <h1>Unit Customer</h1>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-8">
                        <div class="page-header float-right">
                            <div class="page-title">
                                <ol class="breadcrumb text-right">
                                    <li><a href="#">Master</a></li>
                                    <li><a href="#">Unit Customer</a></li>
                                    <li class="active">Ubah Unit Customer</li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Content -->
        <div class="content">
            <div class="animated fadeIn">
                <div class="row">

                    <div class="col-md-12">
                        <div class="card">
                            <div class="card-header">
                                <strong class="card-title">Ubah Unit Customer</strong>
                            </div>
                            <div class="card-body card-block">
                                <form action="<?php echo e(route('item_customer.update', ['item_customer' => $item['id']])); ?>" method="post" enctype="multipart/form-data" class="form-horizontal">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('PUT'); ?>
                                    <div class="row form-group">
                                        <div class="col col-md-3"><label for="text-input" class=" form-control-label">Customer</label></div>
                                        <div class="col-12 col-md-9">
                                           <select name="id_customer" id="id_customer" onchange="pilihCustomer(this.value)" class="form-control" required>

                                           </select>
                                        </div>
                                    </div>

                                    <div class="row form-group">
                                        <div class="col col-md-3"><label for="text-input" class=" form-control-label">Lokasi</label></div>
                                        <div class="col-12 col-md-9">
                                           <select name="id_lokasi" id="id_lokasi" class="form-control" required>
                                                <option value="">-- Pilih alamat --</option>
                                                <?php $__currentLoopData = $lokasi; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $loc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option <?php echo e($item['id_lokasi'] == $loc['id']?'selected':''); ?> value="<?php echo e($loc['id']); ?>"><?php echo e($loc['alamat']); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                           </select>
                                        </div>
                                    </div>

                                    <div class="row form-group">
                                        <div class="col col-md-3"><label for="text-input" class=" form-control-label">Produk</label></div>
                                        <div class="col-12 col-md-9">
                                           <select name="id_produk" id="id_produk" class="form-control" required>

                                           </select>
                                        </div>
                                    </div>

                                    <div class="row form-group">
                                        <div class="col col-md-3"><label for="text-input" class=" form-control-label">Vendor</label></div>
                                        <div class="col-12 col-md-9">
                                           <select name="id_vendor" id="id_vendor" class="form-control" required>

                                           </select>
                                        </div>
                                    </div>

                                    <div class="row form-group">
                                        <div class="col col-md-3"><label for="text-input" class=" form-control-label">Jumlah Unit</label></div>
                                        <div class="col-12 col-md-9">
                                           <select name="unit" id="unit" class="form-control" onchange="jumlahUnit(this.value)" required>
                                                <option value="0"></option>
                                                <?php for($i = 1; $i <= 10; $i++): ?>
                                                    <option <?php echo e($item['unit'] == $i?'selected':''); ?> value="<?php echo e($i); ?>"><?php echo e($i ." Unit"); ?></option>
                                                <?php endfor; ?>
                                           </select>
                                        </div>
                                    </div>
                                    <table class="table table-bordered">
                                        <thead>
                                            <tr>
                                                <th>No</th>
                                                <th>Serial Number</th>
                                                <th>Tanggal Pembelian</th>
                                            </tr>
                                        </thead>
                                        <tbody id="unitTableBody">
                                            <?php $__currentLoopData = $unit; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $units): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td><?php echo e($loop->iteration); ?></td>
                                                    <td>
                                                        <input type="text" name="post[serial_number][]" class="form-control" value="<?php echo e($units['serial_number']); ?>" required>
                                                    </td>
                                                    <td>
                                                        <input type="date" name="post[tgl_pembelian][]" class="form-control"  value="<?php echo e($units['tgl_pembelian']); ?>" required>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                    <button type="submit" class="btn btn-primary">
                                        Simpan
                                    </button>
                                    <a href="<?php echo e(route('item_customer.index')); ?>" class="btn btn-default">
                                        Batal
                                    </button>
                                </form>
                            </div>
                           
                        </div>
                    </div>


                </div>
            </div><!-- .animated -->
        </div><!-- .content -->
        <!-- /.content -->
<?php $__env->startSection('js'); ?>
<script>
    $(document).ready(function() {
        $.ajax({
            url: "<?php echo e(route('get.customers')); ?>",
            type: "GET",
            dataType: "json",
            success: function(data) {
                let select = $('#id_customer');
                select.empty();
                select.append('<option value="">--Pilih Customer--</option>'); // Opsi default
                let selectedCustomerId = "<?php echo e($item['id_customer'] ?? ''); ?>";
                $.each(data, function(index, customers) {
                        let selected = customers.id == selectedCustomerId ? 'selected' : '';
                        select.append('<option value="' + customers.id + '" ' + selected + '>' + customers.nama_customer + '</option>');
                    
                });

                select.trigger("chosen:updated"); // Jika pakai Chosen.js
            },
            error: function(xhr) {
                console.log("Error: " + xhr.responseText);
            }
        });

        $.ajax({
            url: "<?php echo e(route('get.produk')); ?>",
            type: "GET",
            dataType: "json",
            success: function(data) {
                let select = $('#id_produk');
                select.empty();
                select.append('<option value="">--Pilih Produk--</option>'); // Opsi default
                let selectProdukId = "<?php echo e($item['id_produk'] ?? ''); ?>";
                $.each(data, function(index, produk) {
                        let selected = produk.id_produk == selectProdukId ? 'selected' : '';
                        select.append('<option value="' + produk.id_produk + '" ' + selected + '>' + produk.judul + '</option>');
                    
                });

                select.trigger("chosen:updated"); // Jika pakai Chosen.js
            },
            error: function(xhr) {
                console.log("Error: " + xhr.responseText);
            }
        });

        $.ajax({
            url: "<?php echo e(route('get.vendor')); ?>",
            type: "GET",
            dataType: "json",
            success: function(data) {
                let select = $('#id_vendor');
                select.empty();
                select.append('<option value="">--Pilih Vendor--</option>'); // Opsi default
                let selectVendorId = "<?php echo e($item['id_vendor'] ?? ''); ?>";
                $.each(data, function(index, vendor) {
                        let selected = vendor.id == selectVendorId ? 'selected' : '';
                        select.append('<option value="' + vendor.id + '" ' + selected + '>' + vendor.nama_vendor + '</option>');
                    
                });

                select.trigger("chosen:updated"); // Jika pakai Chosen.js
            },
            error: function(xhr) {
                console.log("Error: " + xhr.responseText);
            }
        });
    });

    function pilihCustomer(idCustomer) {
        const alamatSelect = document.getElementById('id_lokasi');
        alamatSelect.innerHTML = '<option value="">-- Memuat alamat... --</option>';

        fetch("<?php echo e(url('/get-customer-alamat')); ?>/" + idCustomer)
            .then(response => response.json())
            .then(data => {
                alamatSelect.innerHTML = '<option value="">-- Pilih alamat --</option>';

                let selectedLokasiId = "<?php echo e($item['id_lokasi'] ?? ''); ?>";

                if (data.length > 0) {
                    data.forEach(item => {
                        const option = document.createElement('option');
                        option.value = item.id;
                        option.textContent = item.alamat;

                        if (item.id == selectedLokasiId) {
                            option.selected = true;
                        }

                        alamatSelect.appendChild(option);
                    });
                } else {
                    const option = document.createElement('option');
                    option.value = '';
                    option.textContent = 'Alamat tidak ditemukan';
                    alamatSelect.appendChild(option);
                }
            })
            .catch(error => {
                console.error('Gagal mengambil alamat:', error);
                alamatSelect.innerHTML = '<option value="">Gagal memuat alamat</option>';
            });
    }


    function jumlahUnit(jumlah) {
        const tbody = document.getElementById('unitTableBody');
        tbody.innerHTML = ''; // Hapus semua baris sebelumnya

        for (let i = 1; i <= jumlah; i++) {
            const row = document.createElement('tr');

            row.innerHTML = `
                <td>${i}</td>
                <td><input type="text" name="post[serial_number][]" class="form-control" required></td>
                <td><input type="date" name="post[tgl_pembelian][]" class="form-control" required></td>
            `;

            tbody.appendChild(row);
        }
    }
</script>
<?php $__env->stopSection(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home3/baktijay/public_html/ptgib.co.id/admin/resources/views/master/item_customer/edit.blade.php ENDPATH**/ ?>