
<?php $__env->startSection('title','Kunjungan Rutin'); ?>
<?php $__env->startSection('content'); ?>
        
        <div class="breadcrumbs">
            <div class="breadcrumbs-inner">
                <div class="row m-0">
                    <div class="col-sm-4">
                        <div class="page-header float-left">
                            <div class="page-title">
                                <h1>Kunjungan Rutin</h1>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-8">
                        <div class="page-header float-right">
                            <div class="page-title">
                                <ol class="breadcrumb text-right">
                                    <li><a href="#">Master</a></li>
                                    <li><a href="#">Kunjungan Rutin</a></li>
                                    <li class="active">Data Kunjungan Rutin</li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Content -->
        <div class="content">
            <div class="animated fadeIn">
                <div class="row">

                    <div class="col-md-12">
                        <div class="card">
                            <div class="card-header">
                                <strong class="card-title">Data Kunjungan</strong>
                            </div>
                            <div class="card-body">
                                <?php echo $__env->make('include.admin.alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <a href="<?php echo e(route('kunjungan.create')); ?>" class="btn btn-primary mb-3">Tambah</a>
                                
                                <table id="dataKunjungan" class="table table-striped table-bordered">
                                    <thead>
                                        <tr>
                                            <th>No.</th>
                                            <th>Nama PIC</th>
                                            <th>Telp</th>
                                            <th>Nama Customer</th>
                                            <th>Lokasi</th>
                                            <th>Tgl. Mulai</th>
                                            <th>Tgl. Selesai</th>
                                            <th>Teknisi</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                   
                                </table>
                            </div>
                        </div>
                    </div>


                </div>
            </div><!-- .animated -->
        </div><!-- .content -->
        <!-- /.content -->
<?php $__env->startSection('js'); ?>
<script>
  $(document).ready(function() {
    var t = $('#dataKunjungan').DataTable({
        processing: true,
        serverSide: true,
        ajax: "<?php echo e(route('kunjungan-data.getData')); ?>",
        columns: [
            {
                data: null,
                name: 'rownum',
                orderable: false,
                searchable: false,
                render: function(data, type, row, meta) {
                    return meta.row + meta.settings._iDisplayStart + 1;
                }
            },
            { data: 'nama_lengkap', name: 'nama_lengkap' },
            { data: 'no_telp', name: 'no_telp' },
            { data: 'nama_customer', name: 'nama_customer' },
            { data: 'alamat', name: 'alamat' },
            { data: 'tgl_mulai', name: 'tgl_mulai' },
            { data: 'tgl_selesai', name: 'tgl_selesai' },
            {
                data: 'teknisi',
                name: 'teknisi',
                render: function(data, type, row) {
                    if (data && data.length > 0) {
                        return data.map(t => t.nama_teknisi).join(', ');
                    }
                    return '-';
                }
            },
            { data: 'action', name: 'action', orderable: false, searchable: false }
        ]
    });
});

</script>
<?php $__env->stopSection(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home3/baktijay/public_html/ptgib.co.id/admin/resources/views/data_transaksi/kunjungan/index.blade.php ENDPATH**/ ?>