
<?php $__env->startSection('title','Unit Customer'); ?>
<?php $__env->startSection('content'); ?>
        
        <div class="breadcrumbs">
            <div class="breadcrumbs-inner">
                <div class="row m-0">
                    <div class="col-sm-4">
                        <div class="page-header float-left">
                            <div class="page-title">
                                <h1>Unit Customer</h1>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-8">
                        <div class="page-header float-right">
                            <div class="page-title">
                                <ol class="breadcrumb text-right">
                                    <li><a href="#">Master</a></li>
                                    <li><a href="#">Unit Customer</a></li>
                                    <li class="active">Tambah Unit Customer</li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Content -->
        <div class="content">
            <div class="animated fadeIn">
                <div class="row">

                    <div class="col-md-12">
                        <div class="card">
                            <div class="card-header">
                                <strong class="card-title">Tambah Unit Customer</strong>
                            </div>
                            <div class="card-body card-block">
                                <form action="<?php echo e(route('item_customer.store')); ?>" method="post" enctype="multipart/form-data" class="form-horizontal">
                                    <?php echo csrf_field(); ?>
                                    <div class="row form-group">
                                        <div class="col col-md-3"><label for="text-input" class=" form-control-label">Customer</label></div>
                                        <div class="col-12 col-md-9">
                                           <select name="id_customer" id="id_customer" onchange="pilihCustomer(this.value)" class="form-control" required>

                                           </select>
                                        </div>
                                    </div>

                                    <div class="row form-group">
                                        <div class="col col-md-3"><label for="text-input" class=" form-control-label">Lokasi</label></div>
                                        <div class="col-12 col-md-9">
                                           <select name="id_lokasi" id="id_lokasi" class="form-control" required>
                                                <option value="">-- Pilih alamat --</option>
                                           </select>
                                        </div>
                                    </div>

                                    <div class="row form-group">
                                        <div class="col col-md-3"><label for="text-input" class=" form-control-label">Produk</label></div>
                                        <div class="col-12 col-md-9">
                                           <select name="id_produk" id="id_produk" class="form-control" required>

                                           </select>
                                        </div>
                                    </div>

                                    <div class="row form-group">
                                        <div class="col col-md-3"><label for="text-input" class=" form-control-label">Vendor</label></div>
                                        <div class="col-12 col-md-9">
                                           <select name="id_vendor" id="id_vendor" class="form-control" required>

                                           </select>
                                        </div>
                                    </div>

                                    <div class="row form-group">
                                        <div class="col col-md-3"><label for="text-input" class=" form-control-label">Jumlah Unit</label></div>
                                        <div class="col-12 col-md-9">
                                           <select name="unit" id="unit" class="form-control" onchange="jumlahUnit(this.value)" required>
                                                <option value="0"></option>
                                                <?php for($i = 1; $i <= 10; $i++): ?>
                                                    <option value="<?php echo e($i); ?>"><?php echo e($i ." Unit"); ?></option>
                                                <?php endfor; ?>
                                           </select>
                                        </div>
                                    </div>
                                    <table class="table table-bordered">
                                        <thead>
                                            <tr>
                                                <th>No</th>
                                                <th>Serial Number</th>
                                                <th>Tanggal Pembelian</th>
                                            </tr>
                                        </thead>
                                        <tbody id="unitTableBody">
                                            <!-- Baris akan muncul di sini -->
                                        </tbody>
                                    </table>
                                    <button type="submit" class="btn btn-primary">
                                        Simpan
                                    </button>
                                    <a href="<?php echo e(route('item_customer.index')); ?>" class="btn btn-default">
                                        Batal
                                    </button>
                                </form>
                            </div>
                           
                        </div>
                    </div>


                </div>
            </div><!-- .animated -->
        </div><!-- .content -->
        <!-- /.content -->
<?php $__env->startSection('js'); ?>
<script>
    $(document).ready(function() {
        $.ajax({
            url: "<?php echo e(route('get.customers')); ?>",
            type: "GET",
            dataType: "json",
            success: function(data) {
                let select = $('#id_customer');
                select.empty();
                select.append('<option value="">--Pilih Customer--</option>'); // Opsi default

                $.each(data, function(index, customers) {
                    
                        select.append('<option value="' + customers.id + '">' + customers.nama_customer + '</option>');
                    
                });

                select.trigger("chosen:updated"); // Jika pakai Chosen.js
            },
            error: function(xhr) {
                console.log("Error: " + xhr.responseText);
            }
        });

        $.ajax({
            url: "<?php echo e(route('get.produk')); ?>",
            type: "GET",
            dataType: "json",
            success: function(data) {
                let select = $('#id_produk');
                select.empty();
                select.append('<option value="">--Pilih Produk--</option>'); // Opsi default

                $.each(data, function(index, produk) {
                    
                        select.append('<option value="' + produk.id_produk + '">' + produk.judul + '</option>');
                    
                });

                select.trigger("chosen:updated"); // Jika pakai Chosen.js
            },
            error: function(xhr) {
                console.log("Error: " + xhr.responseText);
            }
        });

        $.ajax({
            url: "<?php echo e(route('get.vendor')); ?>",
            type: "GET",
            dataType: "json",
            success: function(data) {
                let select = $('#id_vendor');
                select.empty();
                select.append('<option value="">--Pilih Vendor--</option>'); // Opsi default

                $.each(data, function(index, vendor) {
                    
                        select.append('<option value="' + vendor.id + '">' + vendor.nama_vendor + '</option>');
                    
                });

                select.trigger("chosen:updated"); // Jika pakai Chosen.js
            },
            error: function(xhr) {
                console.log("Error: " + xhr.responseText);
            }
        });
    });

    function pilihCustomer(idCustomer) {
        const alamatSelect = document.getElementById('id_lokasi');
        alamatSelect.innerHTML = '<option value="">-- Memuat alamat... --</option>';

        fetch("<?php echo e(url('/get-customer-alamat')); ?>/" + idCustomer)
            .then(response => response.json())
            .then(data => {
                alamatSelect.innerHTML = '<option value="">-- Pilih alamat --</option>';

                if (data.length > 0) {
                    data.forEach(item => {
                        const option = document.createElement('option');
                        option.value = item.id;
                        option.textContent = item.alamat;
                        alamatSelect.appendChild(option);
                    });
                } else {
                    const option = document.createElement('option');
                    option.value = '';
                    option.textContent = 'Alamat tidak ditemukan';
                    alamatSelect.appendChild(option);
                }
            })
            .catch(error => {
                console.error('Gagal mengambil alamat:', error);
                alamatSelect.innerHTML = '<option value="">Gagal memuat alamat</option>';
            });
    }

    function jumlahUnit(jumlah) {
        const tbody = document.getElementById('unitTableBody');
        tbody.innerHTML = ''; // Hapus semua baris sebelumnya

        for (let i = 1; i <= jumlah; i++) {
            const row = document.createElement('tr');

            row.innerHTML = `
                <td>${i}</td>
                <td><input type="text" name="post[serial_number][]" class="form-control" required></td>
                <td><input type="date" name="post[tgl_pembelian][]" class="form-control" required></td>
            `;

            tbody.appendChild(row);
        }
    }
</script>
<?php $__env->stopSection(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home3/baktijay/public_html/ptgib.co.id/admin/resources/views/master/item_customer/create.blade.php ENDPATH**/ ?>