<?php


use App\Models\User;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\LoginController;

use App\Http\Controllers\CaptchaController;
use App\Http\Controllers\HeaderAkunController;
use App\Http\Controllers\JurnalUmumController;
use App\Http\Controllers\LabaRugiController;
use App\Http\Controllers\NeracaAwalController;
use App\Http\Controllers\NeracaController;
use App\Http\Controllers\NeracaSaldoController;
use App\Http\Controllers\PembelianController;
use App\Http\Controllers\PenerimaanController;
use App\Http\Controllers\PengeluaranController;
use App\Http\Controllers\PenjualanController;
use App\Http\Controllers\SettingAksesController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('auth.login');
});

Route::post('/login', [AuthController::class, 'login'])->name('authenticate');
Route::post('/logout', [AuthController::class, 'logout'])->name('logout');
Route::get('/login', [LoginController::class, 'index'])->name('login');


Route::get('/captcha-refresh', function () {
    return response()->json(['captcha' => captcha_src()]);
})->name('captcha.refresh');

Route::group(['middleware' => 'auth'], function () {
    Route::get('/check-username', function (Request $request) {
        $query = User::where('username', $request->query('username'));

        // Abaikan pengecekan jika sedang edit dan ID dikirim
        if ($request->has('id')) {
            $query->where('id', '!=', $request->query('id'));
        }

        $exists = $query->exists();
        return response()->json(['exists' => $exists]);
    });

    Route::get('/home', [HomeController::class, 'index'])->name('home');


    Route::resource('auth', AuthController::class);
    Route::resource('neraca_awal', NeracaAwalController::class);
    Route::resource('neraca_saldo', NeracaSaldoController::class);
    Route::resource('header_coa', HeaderAkunController::class);
    Route::resource('setting_user', SettingAksesController::class);
    Route::get('coa-data/getData', [HeaderAkunController::class, 'getData'])->name('header_coa.getData');
    Route::resource('pembelian', PembelianController::class);
    Route::get('pembelian-data/getData', [PembelianController::class, 'getData'])->name('pembelian.getData');

    Route::get('/pembelian/export/pdf', [PembelianController::class, 'exportPDF'])->name('pembelian.export.pdf');
    Route::get('/pembelian/export/excel', [PembelianController::class, 'exportExcel'])->name('pembelian.export.excel');

    Route::get('/penjualan/export/pdf', [PenjualanController::class, 'exportPDF'])->name('penjualan.export.pdf');
    Route::get('/penjualan/export/excel', [PenjualanController::class, 'exportExcel'])->name('penjualan.export.excel');

    Route::get('/penerimaan/export/pdf', [PenerimaanController::class, 'exportPDF'])->name('penerimaan.export.pdf');
    Route::get('/penerimaan/export/excel', [PenerimaanController::class, 'exportExcel'])->name('penerimaan.export.excel');

    Route::get('/pengeluaran/export/pdf', [PengeluaranController::class, 'exportPDF'])->name('pengeluaran.export.pdf');
    Route::get('/pengeluaran/export/excel', [PengeluaranController::class, 'exportExcel'])->name('pengeluaran.export.excel');

    Route::get('/jurnal_umum/export/pdf', [JurnalUmumController::class, 'exportPDF'])->name('jurnal_umum.export.pdf');
    Route::get('/jurnal_umum/export/excel', [JurnalUmumController::class, 'exportExcel'])->name('jurnal_umum.export.excel');

    Route::get('/neraca_awal/export/pdf', [NeracaAwalController::class, 'exportPDF'])->name('neraca_awal.export.pdf');
    Route::get('/neraca_awal/export/excel', [NeracaAwalController::class, 'exportExcel'])->name('neraca_awal.export.excel');

    Route::get('/neraca_saldo/export/pdf', [NeracaSaldoController::class, 'exportPDF'])->name('neraca_saldo.export.pdf');
    Route::get('/neraca_saldo/export/excel', [NeracaSaldoController::class, 'exportExcel'])->name('neraca_saldo.export.excel');

    Route::get('/neraca/export/pdf', [NeracaController::class, 'exportPDF'])->name('neraca.export.pdf');
    Route::get('/neraca/export/excel', [NeracaController::class, 'exportExcel'])->name('neraca.export.excel');

    Route::get('/laba_rugi/export/pdf', [LabaRugiController::class, 'exportPDF'])->name('laba_rugi.export.pdf');
    Route::get('/laba_rugi/export/excel', [LabaRugiController::class, 'exportExcel'])->name('laba_rugi.export.excel');


    Route::resource('penjualan', PenjualanController::class);
    Route::get('penjualan-data/getData', [PenjualanController::class, 'getData'])->name('penjualan.getData');

    Route::resource('penerimaan', PenerimaanController::class);
    Route::get('penerimaan-data/getData', [PenerimaanController::class, 'getData'])->name('penerimaan.getData');
    Route::post('penerimaan-data/cek-duplikat', [PenerimaanController::class, 'cekDuplikat'])->name('penerimaan.cekDuplikat');

    Route::resource('pengeluaran', PengeluaranController::class);
    Route::get('pengeluaran-data/getData', [PengeluaranController::class, 'getData'])->name('pengeluaran.getData');
    Route::post('pengeluaran-data/cek-duplikat', [PengeluaranController::class, 'cekDuplikat'])->name('pengeluaran.cekDuplikat');

    Route::resource('jurnal_umum', JurnalUmumController::class);
    Route::get('jurnal_umum-data/getData', [JurnalUmumController::class, 'getData'])->name('jurnal_umum.getData');
    Route::post('jurnal_umum-data/cek-duplikat', [JurnalUmumController::class, 'cekDuplikat'])->name('jurnal_umum.cekDuplikat');

    Route::resource('laba_rugi', LabaRugiController::class);

    Route::resource('neraca', NeracaController::class);

    Route::get('/get-users', function (Request $request) {
        $users = User::select('users.id', 'customer.nama_customer', 'users.nama_lengkap', 'customer.id as id_customer')
            ->join('customer', 'customer.id', '=', 'users.id_customer')
            ->orderBy('customer.nama_customer', 'asc')
            ->get();

        return response()->json($users);
    })->name('get.users');
});
