@extends('layouts.master')
@section('title','Pembelian')
@section('content')
        
        <div class="breadcrumbs">
            <div class="breadcrumbs-inner">
                <div class="row m-0">
                    <div class="col-sm-4">
                        <div class="page-header float-left">
                            <div class="page-title">
                                <h1>Pembelian</h1>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-8">
                        <div class="page-header float-right">
                            <div class="page-title">
                                <ol class="breadcrumb text-right">
                                    <li><a href="#">Master</a></li>
                                    <li><a href="#">Pembelian</a></li>
                                    <li class="active">Ubah Pembelian</li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Content -->
        <div class="content">
            <div class="animated fadeIn">
                <div class="row">

                    <div class="col-md-12">
                        <div class="card">
                            <div class="card-header">
                                <strong class="card-title">Ubah Pembelian</strong>
                            </div>
                            <div class="card-body card-block">
                                <form action="{{ route('pembelian.update', ['pembelian' => $data->id]) }}" method="post" enctype="multipart/form-data" class="form-horizontal">
                                    @csrf
                                    @method('PUT')
                                    <div class="row form-group">
                                        <div class="col col-md-3"><label for="text-input" class=" form-control-label">Tanggal</label></div>
                                        <div class="col-12 col-md-4">
                                           <input type="date" class="form-control"  name="tanggal" value="{{ $data->tanggal }}">
                                        </div>
                                    </div>
                                    <div class="row form-group">
                                        <div class="col col-md-3"><label for="text-input" class=" form-control-label">No. Faktur</label></div>
                                        <div class="col-12 col-md-6">
                                            
                                            <input type="text" class="form-control" name="no_faktur" placeholder="No. Faktur" value="{{ $data->no_faktur }}">
                                        </div>
                                    </div>

                                    <div class="row form-group">
                                        <div class="col col-md-3"><label for="text-input" class=" form-control-label">Keterangan</label></div>
                                        <div class="col-12 col-md-6">
                                            
                                            <input type="text" class="form-control" name="keterangan" placeholder="Keterangan" value="{{ $data->keterangan }}">
                                        </div>
                                    </div>

                                    <div class="row form-group">
                                        <div class="col col-md-3"><label for="text-input" class=" form-control-label">Pos Ref</label></div>
                                        <div class="col-12 col-md-6">
                                            
                                            <input type="text" class="form-control" name="ref" placeholder="Pos Ref" value="{{ $data->ref }}">
                                        </div>
                                    </div>

                                    <hr>
                                    <h5>Debit</h5>
                                    <hr>
                                    <div class="row form-group">
                                        <div class="col col-md-3"><label for="text-input" class=" form-control-label">Pembelian</label></div>
                                        <div class="col-12 col-md-6">
                                            
                                            <input type="text" id="pembelian" onkeyup="hitungTotal()" class="form-control" name="persediaan_barang" value="{{ number_format($data->persediaan_barang, 0, ',', '.') }}">
                                        </div>
                                    </div>

                                    <div class="row form-group">
                                        <div class="col col-md-3"><label for="text-input" class=" form-control-label">Biaya Angkut</label></div>
                                        <div class="col-12 col-md-6">
                                            
                                             <input type="text" class="form-control" onkeyup="hitungTotal()" id="biaya_angkut" name="biaya_angkut" value="{{ number_format($data->biaya_angkut, 0, ',', '.') }}">
                                        </div>
                                    </div>

                                    <div class="row form-group">
                                        <div class="col col-md-3"><label for="text-input" class=" form-control-label">PPN Masukan</label></div>
                                        <div class="col-12 col-md-6">
                                            
                                            <input type="text" class="form-control" id="ppn_masukan" name="ppn_masukan" value="{{ number_format($data->ppn_masukan, 0, ',', '.') }}" readonly>
                                        </div>
                                        <div class="col-12 col-md-2">
                                            
                                           <select name="ppn" id="ppn_persen" onchange="hitungTotal()" class="form-control">
                                            <option value="0">0%</option>
                                            <option {{ $data->ppn == 10?'selected':'' }} value="10">10%</option>
                                            <option {{ $data->ppn == 11?'selected':'' }} value="11">11%</option>
                                            <option {{ $data->ppn == 12?'selected':'' }} value="12">12%</option>
                                           </select>
                                        </div>
                                    </div>

                                    <div class="row form-group">
                                        <div class="col col-md-3"><label for="text-input" class=" form-control-label">Discount (%)</label></div>
                                        <div class="col-12 col-md-6">
                                            
                                            <input type="number" class="form-control" onkeyup="hitungTotal()" name="discount" id="discount" value="{{ $data->discount }}">
                                            <input type="hidden" name="nominal_diskon" id="nominal_diskon" value="{{ number_format($data->nominal_diskon, 0, ',', '.') }}">
                                        </div>
                                    </div>

                                    <hr>
                                    <h5>Kredit</h5>
                                    <hr>
                                    <div class="row form-group">
                                        <div class="col col-md-3"><label for="text-input" class=" form-control-label">Hutang Dagang</label></div>
                                        <div class="col-12 col-md-6">
                                            
                                             <input type="text" class="form-control" id="hutang_dagang" name="hutang_dagang" readonly value="{{ number_format($data->hutang_dagang, 0, ',', '.') }}">
                                        </div>
                                    </div>
                                    <button type="submit" class="btn btn-primary">
                                        Simpan
                                    </button>
                                    <a href="{{ route('pembelian.index') }}" class="btn btn-default">
                                        Batal
                                    </button>
                                </form>
                            </div>
                           
                        </div>
                    </div>


                </div>
            </div><!-- .animated -->
        </div><!-- .content -->
        <!-- /.content -->
@section('js')
<!-- Summernote CSS -->
<link href="https://cdnjs.cloudflare.com/ajax/libs/summernote/0.8.18/summernote-lite.min.css" rel="stylesheet">
<!-- Summernote JS -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/summernote/0.8.18/summernote-lite.min.js"></script>

<script>
    

    function formatRupiah(angka) {
        let number_string = angka.replace(/[^,\d]/g, "").toString(),
            split = number_string.split(","),
            sisa  = split[0].length % 3,
            rupiah  = split[0].substr(0, sisa),
            ribuan  = split[0].substr(sisa).match(/\d{3}/gi);

        if (ribuan) {
            let separator = sisa ? "." : "";
            rupiah += separator + ribuan.join(".");
        }
        return split[1] !== undefined ? rupiah + "," + split[1] : rupiah;
    }

    function parseRupiah(nilai) {
        return parseInt(nilai.replace(/\./g, "").replace(/[^0-9]/g, '')) || 0;
    }

    function hitungTotal() {
        let pembelian = parseRupiah(document.getElementById('pembelian').value);
        let biaya = parseRupiah(document.getElementById('biaya_angkut').value);
        let discount_persen = parseFloat(document.getElementById('discount').value) || 0;
        let ppn_persen = parseInt(document.getElementById('ppn_persen').value) || 0;
        let discount = Math.round((pembelian * discount_persen) / 100);
        let total_sebelum_ppn = pembelian + biaya - discount;
        let ppn = Math.round((total_sebelum_ppn * ppn_persen) / 100);
        let total = total_sebelum_ppn + ppn;

        // Format input saat ketik
        document.getElementById('pembelian').value = formatRupiah(pembelian.toString());
        document.getElementById('biaya_angkut').value = formatRupiah(biaya.toString());
        document.getElementById('nominal_diskon').value = formatRupiah(discount.toString());
        
        // Tampilkan hasil
        document.getElementById('ppn_masukan').value = formatRupiah(ppn.toString());
        document.getElementById('hutang_dagang').value = formatRupiah(total.toString());
    }
</script>
@endsection       


@endsection