@extends('layouts.master')
@section('title','Nomor Akun')
@section('content')
        
        <div class="breadcrumbs">
            <div class="breadcrumbs-inner">
                <div class="row m-0">
                    <div class="col-sm-4">
                        <div class="page-header float-left">
                            <div class="page-title">
                                <h1>Nomor Akun</h1>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-8">
                        <div class="page-header float-right">
                            <div class="page-title">
                                <ol class="breadcrumb text-right">
                                    <li><a href="#">Master</a></li>
                                    <li><a href="#">Nomor Akun</a></li>
                                    <li class="active">Data Nomor Akun</li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Content -->
        <div class="content">
            <div class="animated fadeIn">
                <div class="row">

                    <div class="col-md-12">
                        <div class="card">
                            <div class="card-header">
                                <strong class="card-title">Data Nomor Akun</strong>
                            </div>
                            <div class="card-body">
                               
                                <a href="{{ route('header_coa.create') }}" class="btn btn-primary mb-3">Tambah</a>
                                
                                <table id="dataTable" class="table table-striped table-bordered">
                                    <thead>
                                        <tr>
                                            <th>No.</th>
                                            <th>Nomor Akun Header</th>
                                            <th>Nama Akun Header</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                   
                                </table>
                            </div>
                        </div>
                    </div>


                </div>
            </div><!-- .animated -->
        </div><!-- .content -->
        <!-- /.content -->
@section('js')
<script>
  $(document).ready(function() {
    var t = $('#dataTable').DataTable({
        processing: true,
        serverSide: true,
        ajax: "{{ route('header_coa.getData') }}",
        columns: [
            {
                data: null,
                name: 'rownum',
                orderable: false,
                searchable: false,
                render: function(data, type, row, meta) {
                    return meta.row + meta.settings._iDisplayStart + 1;
                }
            },
            { data: 'no_header_akun', name: 'no_header_akun' },
            { data: 'nama_header_akun', name: 'nama_header_akun' },
            
            { data: 'action', name: 'action', orderable: false, searchable: false }
        ]
    });
});

</script>
@endsection
@endsection