@extends('layouts.master')
@section('title','Header Akun')
<style>
    .card-footer>button{
        float: right;
    }
</style>
@section('content')

    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Tambah Header Akun</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="#">Header Akun</a></li>
                        <li class="breadcrumb-item active">Tambah Header Akun</li>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <!-- SELECT2 EXAMPLE -->
            <div class="card card-default">
               <form action="{{ route('header_coa.update', ['header_coa' => $data->id]) }}" method="post" enctype="multipart/form-data" class="form-horizontal">
                    @csrf
                    @method('PUT')
                {{-- @include('include.admin.alert') --}}
                <div class="card-body">
                    <div class="form-group row">
                        <label for="inputEmail3" class="col-sm-2 col-form-label">No. Akun Header</label>
                        <div class="col-sm-4">
                        <input type="text" class="form-control" id="inputEmail3" name="no_header_akun" value="{{ $data->no_header_akun }}" placeholder="Nomor Akun">
                        </div>
                    </div>
                    <div class="form-group row">
                        <label for="inputPassword3" class="col-sm-2 col-form-label">Nama Akun Header</label>
                        <div class="col-sm-6">
                        <input type="text" class="form-control" id="inputPassword3" name="nama_header_akun" value="{{ $data->nama_header_akun }}" placeholder="Nama Akun">
                        </div>
                    </div>
                    <hr>
                    <h5>DETAIL</h5>
                    <table id="detailAkun" class="table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th>Action</th>
                                <th>Nomor Akun</th>
                                <th>Nama Akun</th>
                                
                            </tr>
                        </thead>
                        <tbody>
                            @if ($detail->isNotEmpty())
                                @foreach ($detail as $item)
                                    <tr>
                                        <td>
                                            <button type="button" value="Delete" onclick="deleteAkun(this)" class='btn btn-danger'><i class="fas fa-times"></i></button>
                                        </td>
                                        <td>
                                            <input type="text" name="post[no_akun][]" value="{{ $item['no_akun'] }}" class="form-control">
                                        </td>
                                        <td>
                                            <input type="text" name="post[nama_akun][]" value="{{ $item['nama_akun'] }}" class="form-control">
                                        </td>
                                    </tr> 
                                @endforeach
                            @endif 
                            <tr>
                                <td>
                                    <a onclick="createAkun()" class="btn btn-success"><i class="fas fa-plus"></i></a>
                                </td>
                                <td colspan="3"></td>
                            </tr>
                        </tbody>
                    </table>
                 </div>
                 <!-- /.card-body -->
                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary">Simpan</button>
                        <a href="{{ route('header_coa.index') }}" class="btn btn-default">Batal</a>
                    </div>
                    
               
                
               </form>
               
            </div>
            <!-- /.card -->

            
        </div>
        <!-- /.container-fluid -->
    </section>
    <!-- /.content -->

@section('js')
<script>
    function createAkun() {
        var table = document.getElementById("detailAkun");
        var tbodyRowCount = table.tBodies[0].rows.length;
        var row = table.insertRow(tbodyRowCount);

        var cell1L = row.insertCell(0);
        var cell2L = row.insertCell(1);
        var cell3L = row.insertCell(2);
        //var cell4L = row.insertCell(3);


        cell1L.innerHTML = "<button type='button' value='Delete' onclick='deleteAkun(this)' class='btn btn-danger'><i class='fas fa-times'></i></button>";
        cell2L.innerHTML = '<input type="text" name="post[no_akun][]" class="form-control">';
       
        cell3L.innerHTML = '<input type="text" name="post[nama_akun][]" class="form-control">';
        


    }

    function deleteAkun(btn) {
        var row = btn.parentNode.parentNode;
        row.parentNode.removeChild(row);
        //merek();
    }
</script>
@endsection

@endsection