@extends('layouts.master')
@section('title','Nomor Akun')
@section('content')
        
        <div class="breadcrumbs">
            <div class="breadcrumbs-inner">
                <div class="row m-0">
                    <div class="col-sm-4">
                        <div class="page-header float-left">
                            <div class="page-title">
                                <h1>Nomor Akun</h1>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-8">
                        <div class="page-header float-right">
                            <div class="page-title">
                                <ol class="breadcrumb text-right">
                                    <li><a href="#">Master</a></li>
                                    <li><a href="#">Nomor Akun</a></li>
                                    <li class="active">Tambah Nomor Akun</li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Content -->
        <div class="content">
            <div class="animated fadeIn">
                <div class="row">

                    <div class="col-md-12">
                        <div class="card">
                            <div class="card-header">
                                <strong class="card-title">Tambah Nomor Akun</strong>
                            </div>
                            <div class="card-body card-block">
                                <form action="{{ route('header_coa.store') }}" method="post" enctype="multipart/form-data" class="form-horizontal">
                                    @csrf
                                    <div class="row form-group">
                                        <div class="col col-md-3"><label for="text-input" class=" form-control-label">No. Akun Header</label></div>
                                        <div class="col-12 col-md-9">
                                           <input type="text" class="form-control" id="inputEmail3" name="no_header_akun" placeholder="Nomor Akun">
                                        </div>
                                    </div>
                                    <div class="row form-group">
                                        <div class="col col-md-3"><label for="text-input" class=" form-control-label">Nama Akun Header</label></div>
                                        <div class="col-12 col-md-9">
                                            
                                            <input type="text" class="form-control" id="inputPassword3" name="nama_header_akun" placeholder="Nama Akun">
                                        </div>
                                    </div>
                                    <div class="row form-group">
                                        <div class="col col-md-3"><label for="text-input" class=" form-control-label">Tipe Akun</label></div>
                                        <div class="col-12 col-md-9">
                                            
                                            <select name="tipe_akun" class="form-control" required>
                                                <option value="">--Pilih--</option>
                                                <option value="Kas/Bank">Kas/Bank</option>
                                                <option value="Akun Piutang">Akun Piutang</option>
                                                <option value="Aktiva Lancar Lainnya">Aktiva Lancar Lainnya</option>
                                                <option value="Aktiva Tetap">Aktiva Tetap</option>
                                                <option value="Akumulasi">Akumulasi</option>
                                                <option value="Akun Hutang Lancar">Akun Hutang Lancar</option>
                                                <option value="Hutang Lancar Lainnya">Akun Hutang Lancar Lainnya</option>
                                                <option value="Hutang Jangka">Hutang Jangka</option>
                                                <option value="Ekuitas">Ekuitas</option>
                                                <option value="Pendapatan">Pendapatan</option>
                                                <option value="Harga Pokok">Harga Pokok</option>
                                                <option value="Beban">Beban</option>
                                                <option value="Pendapatan Lain">Pendapatan Lain</option>
                                                <option value="Beban Lain-Lain">Beban Lain-Lain</option>
                                            </select>
                                        </div>
                                    </div>
                                    
                                    <hr>
                                    <h5>DETAIL</h5>
                                    <table id="detailAkun" class="table table-bordered table-striped">
                                        <thead>
                                            <tr>
                                                <th>Action</th>
                                                <th>Nomor Akun</th>
                                                <th>Nama Akun</th>
                                                
                                            </tr>
                                        </thead>
                                        
                                            
                                        
                                        <tbody>
                                        
                                            <tr>
                                                <td>
                                                    <a onclick="createAkun()" class="btn btn-success"><i class="fas fa-plus"></i></a>
                                                </td>
                                                <td colspan="3"></td>
                                            </tr>
                                        
                                        </tbody>
                                    </table>
                                    <button type="submit" class="btn btn-primary">
                                        Simpan
                                    </button>
                                    <a href="{{ route('header_coa.index') }}" class="btn btn-default">
                                        Batal
                                    </button>
                                </form>
                            </div>
                           
                        </div>
                    </div>


                </div>
            </div><!-- .animated -->
        </div><!-- .content -->
        <!-- /.content -->
@section('js')
<!-- Summernote CSS -->
<link href="https://cdnjs.cloudflare.com/ajax/libs/summernote/0.8.18/summernote-lite.min.css" rel="stylesheet">
<!-- Summernote JS -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/summernote/0.8.18/summernote-lite.min.js"></script>

<script>
    function createAkun() {
        var table = document.getElementById("detailAkun");
        var tbodyRowCount = table.tBodies[0].rows.length;
        var row = table.insertRow(tbodyRowCount);

        var cell1L = row.insertCell(0);
        var cell2L = row.insertCell(1);
        var cell3L = row.insertCell(2);
        //var cell4L = row.insertCell(3);


        cell1L.innerHTML = "<button type='button' value='Delete' onclick='deleteAkun(this)' class='btn btn-danger'><i class='fas fa-times'></i></button>";
        cell2L.innerHTML = '<input type="text" name="post[no_akun][]" class="form-control">';
       
        cell3L.innerHTML = '<input type="text" name="post[nama_akun][]" class="form-control">';
        


    }

    function deleteAkun(btn) {
        var row = btn.parentNode.parentNode;
        row.parentNode.removeChild(row);
        //merek();
    }
</script>
@endsection       


@endsection