@extends('layouts.master')
@section('title','Jurnal Umum')
@section('content')
        
        <div class="breadcrumbs">
            <div class="breadcrumbs-inner">
                <div class="row m-0">
                    <div class="col-sm-4">
                        <div class="page-header float-left">
                            <div class="page-title">
                                <h1>Jurnal Umum</h1>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-8">
                        <div class="page-header float-right">
                            <div class="page-title">
                                <ol class="breadcrumb text-right">
                                    <li><a href="#">Master</a></li>
                                    <li><a href="#">Jurnal Umum</a></li>
                                    <li class="active">Tambah Jurnal Umum</li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Content -->
        <div class="content">
            <div class="animated fadeIn">
                <div class="row">

                    <div class="col-md-12">
                        <div class="card">
                            <div class="card-header">
                                <strong class="card-title">Tambah Jurnal Umum</strong>
                            </div>
                            <div class="card-body card-block">
                                <form id="form-jurnal" action="{{ route('jurnal_umum.store') }}" method="post" enctype="multipart/form-data" class="form-horizontal">
                                    @csrf
                                    <div class="row form-group">
                                        <div class="col col-md-3"><label for="text-input" class=" form-control-label">Tanggal</label></div>
                                        <div class="col-12 col-md-4">
                                           <input type="date" class="form-control"  name="tanggal" value="{{ date('Y-m-d') }}">
                                        </div>
                                    </div>
                                   

                                    <hr>
                                    <h5>Debit</h5>
                                    <hr>
                                    <div class="row form-group">
                                        <div class="col col-md-3"><label for="text-input" class=" form-control-label">Nama Akun</label></div>
                                        <div class="col-12 col-md-6">
                                            
                                            <select name="no_akun_debet" class="form-control select2" required>
                                                <option value="">--Pilih Akun--</option>
                                                @foreach ($header_coa as $header)
                                                    <optgroup label="{{ $header->no_header_akun }} - {{ $header->nama_header_akun }}">
                                                        @foreach ($header->masterCoa as $item)
                                                            <option value="{{ $item->no_akun }}">
                                                                {{ $item->no_akun }} - {{ $item->nama_akun }}
                                                            </option>
                                                        @endforeach
                                                    </optgroup>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>

                                    <div class="row form-group">
                                        <div class="col col-md-3"><label for="text-input" class=" form-control-label">Jumlah</label></div>
                                        <div class="col-12 col-md-6">
                                            
                                             <input type="text" class="form-control" onkeyup="hitungTotal()" id="debet" name="debet">
                                        </div>
                                    </div>

                                    

                                    <hr>
                                    <h5>Kredit</h5>
                                    <hr>
                                    <div class="row form-group">
                                        <div class="col col-md-3"><label for="text-input" class=" form-control-label">Nama Akun</label></div>
                                        <div class="col-12 col-md-6">
                                            
                                            <select name="no_akun_kredit" class="form-control select2" required>
                                                <option value="">--Pilih Akun--</option>
                                                @foreach ($header_coa as $header)
                                                    <optgroup label="{{ $header->no_header_akun }} - {{ $header->nama_header_akun }}">
                                                        @foreach ($header->masterCoa as $item)
                                                            <option value="{{ $item->no_akun }}">
                                                                {{ $item->no_akun }} - {{ $item->nama_akun }}
                                                            </option>
                                                        @endforeach
                                                    </optgroup>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    <div class="row form-group">
                                        <div class="col col-md-3"><label for="text-input" class=" form-control-label">Jumlah</label></div>
                                        <div class="col-12 col-md-6">
                                            
                                             <input type="text" class="form-control" id="kredit" name="kredit" readonly>
                                        </div>
                                    </div>

                                    <div class="row form-group">
                                        <div class="col col-md-3"><label for="text-input" class=" form-control-label">Keterangan</label></div>
                                        <div class="col-12 col-md-6">
                                            
                                             <input type="text" class="form-control" id="keterangan" name="keterangan">
                                        </div>
                                    </div>
                                    <button type="submit" class="btn btn-primary">
                                        Simpan
                                    </button>
                                    <a href="{{ route('jurnal_umum.index') }}" class="btn btn-default">
                                        Batal
                                    </button>
                                </form>
                            </div>
                           
                        </div>
                    </div>


                </div>
            </div><!-- .animated -->
        </div><!-- .content -->
        <!-- /.content -->
@section('js')


<script>
    

    function formatRupiah(angka) {
        let number_string = angka.replace(/[^,\d]/g, "").toString(),
            split = number_string.split(","),
            sisa  = split[0].length % 3,
            rupiah  = split[0].substr(0, sisa),
            ribuan  = split[0].substr(sisa).match(/\d{3}/gi);

        if (ribuan) {
            let separator = sisa ? "." : "";
            rupiah += separator + ribuan.join(".");
        }
        return split[1] !== undefined ? rupiah + "," + split[1] : rupiah;
    }

    function parseRupiah(nilai) {
        return parseInt(nilai.replace(/\./g, "").replace(/[^0-9]/g, '')) || 0;
    }

    function hitungTotal() {
        let debet = parseRupiah(document.getElementById('debet').value);
        
        // Format input saat ketik
        document.getElementById('kredit').value = formatRupiah(debet.toString());
        document.getElementById('debet').value = formatRupiah(debet.toString());
        
    }

    $(document).ready(function () {
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        $('#form-jurnal').on('submit', function (e) {
            e.preventDefault();
            var debetValue = $('input[name="debet"]').val().replace(/\./g, '');
            var kreditValue = $('input[name="kredit"]').val().replace(/\./g, '');
            $.ajax({
                url: "{{ route('jurnal_umum.cekDuplikat') }}",
                method: 'POST',
                data: {
                    id: $('input[name="id"]').val(),
                    tanggal: $('input[name="tanggal"]').val(),
                    id_coa_debet: $('select[name="id_coa_debet"]').val(),
                    id_coa_kredit: $('select[name="id_coa_kredit"]').val(),
                    debet: debetValue,
                    kredit: kreditValue
                },
                success: function (response) {
                    if (response.duplikat) {
                        alert('Data duplikat! Tidak bisa disimpan.');
                        e.preventDefault();
                    } else {
                        e.currentTarget.submit(); // lanjut submit
                    }
                }
            });
        });
    });


   
</script>
@endsection       
@endsection