<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class MasterCoa extends Model
{
    use HasFactory;
    protected $table = 'master_coa';
    protected $guarded = ['id'];
    public function header()
    {
        return $this->belongsTo(HeaderCoa::class, 'id_header_coa');
    }
    public function penerimaanDebet()
    {
        return $this->hasMany(Penerimaan::class, 'no_akun_debet', 'no_akun');
    }

    public function penerimaanKredit()
    {
        return $this->hasMany(Penerimaan::class, 'no_akun_kredit', 'no_akun');
    }

    public function pengeluaranDebet()
    {
        return $this->hasMany(Pengeluaran::class, 'no_akun_debet', 'no_akun');
    }

    public function pengeluaranKredit()
    {
        return $this->hasMany(Pengeluaran::class, 'no_akun_kredit', 'no_akun');
    }

    public function jurnalUmumDebet()
    {
        return $this->hasMany(JurnalUmum::class, 'no_akun_debet', 'no_akun');
    }

    public function jurnalUmumKredit()
    {
        return $this->hasMany(JurnalUmum::class, 'no_akun_kredit', 'no_akun');
    }
    public function neraca_awal()
    {
        return $this->hasMany(NeracaAwal::class, 'no_akun', 'no_akun');
    }
}
