<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use Illuminate\Support\Facades\Auth;

use App\Models\HeaderCoa;
use App\Models\MasterCoa;
use App\Models\Penjualan;
use Yajra\DataTables\Facades\DataTables;
use App\Exports\PenjualanExport;
use Maatwebsite\Excel\Facades\Excel;
use Barryvdh\DomPDF\Facade\Pdf;
use Carbon\Carbon;

class PenjualanController extends Controller
{
    public function index()
    {

        return view('penjualan.index');
    }

    public function exportExcel(Request $request)
    {
        [$year, $month] = explode('-', $request->input('month'));
        setlocale(LC_TIME, 'id_ID.UTF-8');
        Carbon::setLocale('id');
        $bulanIndonesia = Carbon::createFromFormat('m', $month)->translatedFormat('F');

        return Excel::download(new PenjualanExport($month, $year, $bulanIndonesia), 'penjualan ' . $bulanIndonesia . ' ' . $year . '.xlsx');
    }

    public function exportPDF(Request $request)
    {
        [$year, $month] = explode('-', $request->input('month'));
        setlocale(LC_TIME, 'id_ID.UTF-8');
        Carbon::setLocale('id');
        $bulanIndonesia = Carbon::createFromFormat('m', $month)->translatedFormat('F');
        $data = Penjualan::whereYear('tanggal', $year)
            ->whereMonth('tanggal', $month)
            ->get();

        $pdf = PDF::loadView('penjualan.pdf', compact('data', 'month', 'year', 'bulanIndonesia'))->setPaper('A4', 'landscape');
        return $pdf->download('penjualan ' . $bulanIndonesia . ' ' . $year . '.pdf');
    }

    public function create()
    {
        //$data = HeaderCoa::all();
        return view('penjualan.create');
    }
    public function edit($id)
    {
        //$foto = Slider::all();
        //dd($sejarah);
        $data = Penjualan::findOrFail($id);


        //dd($detail);
        return view('penjualan.edit', compact('data'));
    }

    public function store(Request $request)
    {
        $storeData = [
            'tanggal' => $request->input('tanggal'),
            'no_faktur' => $request->input('no_faktur'),
            'keterangan' => $request->input('keterangan'),
            'ref' => $request->input('ref'),
            'biaya_angkut' => str_replace('.', '', $request->input('biaya_angkut')),
            'ppn_keluaran' => str_replace('.', '', $request->input('ppn_keluaran')),
            'ppn' => $request->input('ppn'),
            'piutang_dagang' => str_replace('.', '', $request->input('piutang_dagang')),
            'pph_nominal' => str_replace('.', '', $request->input('pph_nominal')),
            'potongan_lain' => str_replace('.', '', $request->input('potongan_lain')),
            'penjualan' => str_replace('.', '', $request->input('penjualan')),
            'discount' => $request->input('discount'),
            'nominal_diskon' => str_replace('.', '', $request->input('nominal_diskon')),
            'id_user' => Auth::user()->id
        ];
        Penjualan::create($storeData);

        //return redirect()->route('header_coa.edit', $header->id)->with('alert-success', 'Success Tambah Data');\
        return redirect('penjualan')->with('alert-success', 'Success tambah data');
    }

    public function update(Request $request, $id)
    {
        $updateData = [
            'tanggal' => $request->input('tanggal'),
            'no_faktur' => $request->input('no_faktur'),
            'keterangan' => $request->input('keterangan'),
            'ref' => $request->input('ref'),
            'biaya_angkut' => str_replace('.', '', $request->input('biaya_angkut')),
            'ppn_keluaran' => str_replace('.', '', $request->input('ppn_keluaran')),
            'ppn' => $request->input('ppn'),
            'pph_nominal' => str_replace('.', '', $request->input('pph_nominal')),
            'potongan_lain' => str_replace('.', '', $request->input('potongan_lain')),
            'piutang_dagang' => str_replace('.', '', $request->input('piutang_dagang')),
            'penjualan' => str_replace('.', '', $request->input('penjualan')),
            'discount' => $request->input('discount'),
            'nominal_diskon' => str_replace('.', '', $request->input('nominal_diskon')),
            'id_user' => Auth::user()->id
        ];
        Penjualan::where('id', $id)->update($updateData);


        return redirect('penjualan')->with('alert-success', 'Success update data');
        //return redirect()->route('pembelian.edit', $id)->with('alert-success', 'Success Update Data');
    }

    public function destroy($id)
    {
        Penjualan::findOrFail($id)->delete();
        //MasterCoa::where('id_header_coa', $id)->delete();
        return redirect('penjualan')->with('alert-success', 'Success deleted data');
    }

    public function getData(Request $request)
    {
        if ($request->ajax()) {

            $query = Penjualan::select('penjualan.*');

            // Filter berdasarkan month (format: YYYY-MM)
            if ($request->filled('month')) {
                [$year, $month] = explode('-', $request->input('month'));
                $query->whereYear('tanggal', $year)
                    ->whereMonth('tanggal', $month);
            }

            $data = $query->orderBy('penjualan.id', 'desc')
                ->get()
                ->map(function ($item) {
                    $item->tanggal = $item->tanggal
                        ? \Carbon\Carbon::parse($item->tanggal)->format('d/m/Y')
                        : null;
                    $item->piutang_dagang = number_format($item->piutang_dagang);
                    $item->penjualan = number_format($item->penjualan);
                    $item->biaya_angkut = number_format($item->biaya_angkut);
                    $item->ppn_keluaran = number_format($item->ppn_keluaran);
                    $item->pph_nominal = number_format($item->pph_nominal);
                    $item->discount = $item->discount . ' %';
                    return $item;
                });

            //ddd($data);
            return Datatables::of($data)
                ->addColumn('action', function ($row) {
                    $editRoute = route('penjualan.edit', ['penjualan' => $row->id]);
                    //$showRoute = route('header_coa.show', ['header_coa' => $row->id]);
                    $deleteRoute = route('penjualan.destroy', ['penjualan' => $row->id]);
                    $btn = '<form method="POST" action="' . $deleteRoute . '" style="margin-left: 10px;" onsubmit="return confirm(\'Apakah anda yakin?\')">';
                    $btn .= '<div class="btn-group">';
                    $btn .= '<a href="' . $editRoute . '" class="btn btn-warning">Edit</a>';
                    //$btn .= '<a href="' . $showRoute . '" class="btn btn-success ml-2">Detail</a>';
                    $btn .= '<button type="submit" class="btn btn-danger ml-2">Hapus</button>';
                    $btn .= csrf_field(); // Blade directive for CSRF token
                    $btn .= method_field("DELETE"); // Blade directive for HTTP method spoofing

                    $btn .= '</div>';
                    $btn .= '</form>';

                    return $btn;
                })
                ->rawColumns(['action'])
                ->make(true);
        }
    }
}
