<?php

namespace App\Http\Controllers;

use App\Models\HeaderCoa;
use App\Models\MasterCoa;
use App\Models\Pembelian;

use App\Models\Penjualan;
use App\Models\JurnalUmum;
use App\Models\NeracaAwal;
use App\Models\Penerimaan;
use App\Models\Pengeluaran;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Yajra\DataTables\Facades\DataTables;
use App\Exports\NeracaAwalExport;
use Maatwebsite\Excel\Facades\Excel;
use Barryvdh\DomPDF\Facade\Pdf;
use Carbon\Carbon;

class NeracaAwalController extends Controller
{
    public function index()
    {
        $year =  request()->get('year') ? request()->get('year') : date('Y');
        $data = NeracaAwal::where('tahun', $year)->get();
        $neraca_awal_sebelumnya = NeracaAwal::where('tahun', ($year - 1))->get();
        $penerimaan = Penerimaan::whereYear('tanggal', ($year - 1))->get();
        $pengeluaran = Pengeluaran::whereYear('tanggal', ($year - 1))->get();
        $jurnal_umum = JurnalUmum::whereYear('tanggal', ($year - 1))->get();

        $penjualan = Penjualan::selectRaw('
        SUM(piutang_dagang) as piutang_dagang,
        SUM(penjualan) as penjualan,
        SUM(biaya_angkut) as biaya_angkut,
        SUM(nominal_diskon) as nominal_diskon,
        SUM(ppn_keluaran) as ppn_keluaran')
            ->whereRaw("YEAR(tanggal) = ?", [($year - 1)])
            ->first();

        $pembelian = Pembelian::selectRaw('
        SUM(hutang_dagang) as hutang_dagang,
        SUM(persediaan_barang) as persediaan_barang,
        SUM(biaya_angkut) as biaya_angkut,
        SUM(nominal_diskon) as nominal_diskon,
        SUM(ppn_masukan) as ppn_masukan')
            ->whereRaw("YEAR(tanggal) = ?", [($year - 1)])
            ->first();
        //$pembelian = Pembelian::whereYear('tanggal', ($year - 1))->get();
        //$penjualan = Penjualan::whereYear('tanggal', ($year - 1))->get();
        $master_akun = MasterCoa::orderBy('no_akun', 'asc')->get();
        return view('neraca_awal.index', compact('data', 'master_akun', 'penerimaan', 'pengeluaran', 'jurnal_umum', 'pembelian', 'penjualan', 'neraca_awal_sebelumnya'));
    }

    public function exportExcel(Request $request)
    {
        $year = $request->input('year') ?? date('Y');


        return Excel::download(new NeracaAwalExport($year), 'neraca awal ' . $year . '.xlsx');
    }

    public function exportPDF(Request $request)
    {
        $year =  request()->get('year') ? request()->get('year') : date('Y');
        $data = NeracaAwal::where('tahun', $year)->get();
        $neraca_awal_sebelumnya = NeracaAwal::where('tahun', ($year - 1))->get();
        $penerimaan = Penerimaan::whereYear('tanggal', ($year - 1))->get();
        $pengeluaran = Pengeluaran::whereYear('tanggal', ($year - 1))->get();
        $jurnal_umum = JurnalUmum::whereYear('tanggal', ($year - 1))->get();

        $penjualan = Penjualan::selectRaw('
        SUM(piutang_dagang) as piutang_dagang,
        SUM(penjualan) as penjualan,
        SUM(biaya_angkut) as biaya_angkut,
        SUM(nominal_diskon) as nominal_diskon,
        SUM(ppn_keluaran) as ppn_keluaran')
            ->whereRaw("YEAR(tanggal) = ?", [($year - 1)])
            ->first();

        $pembelian = Pembelian::selectRaw('
        SUM(hutang_dagang) as hutang_dagang,
        SUM(persediaan_barang) as persediaan_barang,
        SUM(biaya_angkut) as biaya_angkut,
        SUM(nominal_diskon) as nominal_diskon,
        SUM(ppn_masukan) as ppn_masukan')
            ->whereRaw("YEAR(tanggal) = ?", [($year - 1)])
            ->first();
        //$pembelian = Pembelian::whereYear('tanggal', ($year - 1))->get();
        //$penjualan = Penjualan::whereYear('tanggal', ($year - 1))->get();
        $master_akun = MasterCoa::orderBy('no_akun', 'asc')->get();

        $pdf = PDF::loadView('neraca_awal.pdf', compact('data', 'master_akun', 'penerimaan', 'pengeluaran', 'jurnal_umum', 'pembelian', 'penjualan', 'neraca_awal_sebelumnya', 'year'));
        return $pdf->download('neraca awal ' . $year . '.pdf');
    }



    public function store(Request $request)
    {
        $year =  request()->get('year') ? request()->get('year') : date('Y');
        NeracaAwal::where('tahun', $year)->delete();

        $fieldNames = array("debet", "kredit", "no_akun");

        for ($i = 0; $i < count($_POST['data_post'][$fieldNames[0]]); $i++) {


            $storeData = [
                'id_user' => Auth::user()->id,
                'tahun' => $year,
                'no_akun' => $_POST['data_post']['no_akun'][$i],
                'debet' => $_POST['data_post']['debet'][$i] ? str_replace('.', '', $_POST['data_post']['debet'][$i]) : 0,
                'kredit' =>  $_POST['data_post']['kredit'][$i] ? str_replace('.', '', $_POST['data_post']['kredit'][$i]) : 0,
            ];
            NeracaAwal::create($storeData);
        }
        //return redirect()->route('header_coa.edit', $header->id)->with('alert-success', 'Success Tambah Data');\
        return redirect('neraca_awal')->with('alert-success', 'Success tambah data');
    }
}
