<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use Illuminate\Support\Facades\Auth;

use App\Models\HeaderCoa;
use App\Models\MasterCoa;
use Yajra\DataTables\Facades\DataTables;

class HeaderAkunController extends Controller
{
    public function index()
    {
        $data = HeaderCoa::all();
        return view('master.header_coa.index', compact('data'));
    }

    public function create()
    {
        $data = HeaderCoa::all();
        return view('master.header_coa.create', compact('data'));
    }
    public function edit($id)
    {
        //$foto = Slider::all();
        //dd($sejarah);
        $data = HeaderCoa::findOrFail($id);
        $detail = MasterCoa::where('id_header_coa', $id)->get();

        //dd($detail);
        return view('master.header_coa.edit', compact('data', 'detail'));
    }

    public function store(Request $request)
    {
        $storeData = [

            'no_header_akun' => $request->input('no_header_akun'),
            'nama_header_akun' => $request->input('nama_header_akun'),
            'tipe_akun' => $request->input('tipe_akun')
        ];
        $header = HeaderCoa::create($storeData);
        if (isset($_POST['post'])) {
            $fieldNames = array("no_akun", "nama_akun");
            for ($i = 0; $i < count($_POST['post'][$fieldNames[0]]); $i++) {
                if (!empty($_POST['post']['nama_akun'][$i])) {


                    $store = [
                        'id_header_coa' => $header->id,

                        'no_akun' => $_POST['post']['no_akun'][$i],
                        'nama_akun' => $_POST['post']['nama_akun'][$i]
                    ];

                    MasterCoa::create($store);
                }
            }
        }
        return redirect()->route('header_coa.edit', $header->id)->with('alert-success', 'Success Tambah Data');
    }

    public function update(Request $request, $id)
    {
        $updateData = [
            'no_header_akun' => $request->input('no_header_akun'),
            'nama_header_akun' => $request->input('nama_header_akun'),
            'tipe_akun' => $request->input('tipe_akun')
        ];
        HeaderCoa::where('id', $id)->update($updateData);

        if (isset($_POST['post'])) {
            MasterCoa::where('id_header_coa', $id)->delete();
            $fieldNames = array("no_akun", "nama_akun");
            for ($i = 0; $i < count($_POST['post'][$fieldNames[0]]); $i++) {
                if (!empty($_POST['post']['nama_akun'][$i])) {


                    $store = [
                        'id_header_coa' => $id,

                        'no_akun' => $_POST['post']['no_akun'][$i],
                        'nama_akun' => $_POST['post']['nama_akun'][$i]
                    ];

                    MasterCoa::create($store);
                }
            }
        }

        return redirect()->route('header_coa.edit', $id)->with('alert-success', 'Success Update Data');
    }

    public function destroy($id)
    {
        HeaderCoa::findOrFail($id)->delete();
        MasterCoa::where('id_header_coa', $id)->delete();
        return redirect('header_coa')->with('alert-success', 'Success deleted data');
    }

    public function getData(Request $request)
    {
        if ($request->ajax()) {
            $data = HeaderCoa::select(
                'header_coa.*'
            )


                ->orderBy('header_coa.id', 'desc')
                ->get()
                ->map(function ($item) {

                    return $item;
                });



            return Datatables::of($data)
                ->addColumn('action', function ($row) {
                    $editRoute = route('header_coa.edit', ['header_coa' => $row->id]);
                    //$showRoute = route('header_coa.show', ['header_coa' => $row->id]);
                    $deleteRoute = route('header_coa.destroy', ['header_coa' => $row->id]);
                    $btn = '<form method="POST" action="' . $deleteRoute . '" style="margin-left: 10px;" onsubmit="return confirm(\'Apakah anda yakin?\')">';
                    $btn .= '<div class="btn-group">';
                    $btn .= '<a href="' . $editRoute . '" class="btn btn-warning">Edit</a>';
                    //$btn .= '<a href="' . $showRoute . '" class="btn btn-success ml-2">Detail</a>';
                    $btn .= '<button type="submit" class="btn btn-danger ml-2">Hapus</button>';
                    $btn .= csrf_field(); // Blade directive for CSRF token
                    $btn .= method_field("DELETE"); // Blade directive for HTTP method spoofing

                    $btn .= '</div>';
                    $btn .= '</form>';

                    return $btn;
                })
                ->rawColumns(['action'])
                ->make(true);
        }
    }
}
