<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Log;

class CaptchaController extends Controller
{
    public function showLogin()
    {
        // TIDAK perlu generate captcha di sini
        return view('auth.login');
    }

    public function generateCaptcha()
    {
        // Buat angka random
        $captcha = rand(1000, 9999);

        // Simpan ke session
        session()->put('captcha', $captcha);

        // Buat gambar dari angka tersebut
        $image = imagecreate(100, 40);
        $bgColor = imagecolorallocate($image, 255, 255, 255);
        $textColor = imagecolorallocate($image, 0, 0, 0);
        imagestring($image, 5, 25, 10, $captcha, $textColor);

        ob_start();
        imagepng($image);
        $imageData = ob_get_clean();

        imagedestroy($image);

        return response($imageData)->header('Content-Type', 'image/png');
    }

    public function handleLogin(Request $request)
    {


        $validator = Validator::make($request->all(), [
            'username' => 'required',
            'password' => 'required',
            'captcha' => 'required',
        ]);

        if ($validator->fails()) {
            return back()->withErrors($validator)->withInput();
        }

        $credentials = $request->only('username', 'password');

        if ($request->captcha != Session::get('captcha')) {
            return back()->withErrors(['captcha' => 'Captcha salah']);
        }

        if (Auth::attempt($credentials)) {
            $request->session()->regenerate();
            return redirect()->intended('/home');
        }

        return back()->with('alert-danger', 'Login Failed!');
        // Login logic...
    }
}
