<?php

namespace App\Exports;

use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;

class NeracaSaldoExport implements FromView
{
    protected $data;
    protected $master_akun;
    protected $penerimaan;
    protected $pengeluaran;
    protected $jurnal_umum;
    protected $pembelian;
    protected $penjualan;
    protected $neraca_awal_sebelumnya;
    protected $year;



    public function __construct($data, $master_akun, $penerimaan, $pengeluaran, $jurnal_umum, $pembelian, $penjualan, $neraca_awal_sebelumnya, $year)
    {
        $this->data = $data;
        $this->master_akun = $master_akun;
        $this->penerimaan = $penerimaan;
        $this->pengeluaran = $pengeluaran;
        $this->jurnal_umum = $jurnal_umum;
        $this->pembelian = $pembelian;
        $this->penjualan = $penjualan;
        $this->neraca_awal_sebelumnya = $neraca_awal_sebelumnya;
        $this->year = $year;
    }

    public function view(): View
    {
        return view('laporan.neraca_saldo.excel', [
            'data' => $this->data,
            'master_akun' => $this->master_akun,
            'penerimaan' => $this->penerimaan,
            'pengeluaran' => $this->pengeluaran,
            'jurnal_umum' => $this->jurnal_umum,
            'pembelian' => $this->pembelian,
            'penjualan' => $this->penjualan,
            'neraca_awal_sebelumnya' => $this->neraca_awal_sebelumnya,
            'year' => $this->year,
        ]);
    }
}
