<?php $__env->startSection('title','Maps Lokasi Kegiatan'); ?>
<?php $__env->startSection('css'); ?>
<link rel="stylesheet" href="https://unpkg.com/leaflet@1.0.3/dist/leaflet.css" integrity="sha512-07I2e+7D8p6he1SIM+1twR5TIrhUQn9+I6yjqD53JQjFiMf8EtC93ty0/5vJTZGF8aAocvHYNEDJajGdNx1IsQ==" crossorigin="" />
<script src="https://unpkg.com/leaflet@1.0.3/dist/leaflet-src.js" integrity="sha512-WXoSHqw/t26DszhdMhOXOkI7qCiv5QWXhH9R7CgvgZMHz1ImlkVQ3uNsiQKu5wwbbxtPzFXd1hK4tzno2VqhpA==" crossorigin=""></script>
<link rel="stylesheet" href="<?php echo e(asset('assets/css/maps/screen.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/css/maps/MarkerCluster.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/css/maps/MarkerCluster.Default.css')); ?>">
<script src="<?php echo e(asset('assets/js/maps/leaflet.markercluster-src.js')); ?>"></script>
<style>
    #map {
        width: 100%;
        height: 600px;
        border: 1px solid #ccc;
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<!-- Content Header (Page header) -->
<section class="content-header">
  <div class="container-fluid">
    <div class="row mb-2">
      <div class="col-sm-6">
        <h1>Maps Lokasi Kegiatan</h1>
      </div>
      <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
          <li class="breadcrumb-item"><a href="#">Maps Lokasi Kegiatan</a></li>
          <li class="breadcrumb-item active">List</li>
        </ol>
      </div>
    </div>
  </div><!-- /.container-fluid -->
</section>

<!-- Main content -->
<section class="content">
  <div class="container-fluid">
    <div class="row">
      <div class="col-12">
        <div class="card">
          <div class="card-header">
            <h4 class="card-title"></h4>
          </div>
          <div class="card-body">
            <div id="map"></div>
            <select name="id_lokasi" style="margin-top:5px;" class="form-control" id="id_lokasi">
              <option value="">Select Location</option>
              <?php $__currentLoopData = $kegiatan; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($value->id); ?>" data-lat="<?php echo e($value->latitude); ?>" data-lng="<?php echo e($value->longitude); ?>">
                  <?php echo e($value->nama_kegiatan.' Detail Lokasi : '.$value->detail_lokasi.' Provinsi '.$value['nama_provinsi'].' Kabupaten Kota '.$value['nama_kabupaten_kota']); ?>

                </option>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
          </div>
        </div>
      </div>
    </div>
  </div><!-- /.container-fluid -->
</section>
<!-- /.content -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script>
    var tiles = L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
        maxZoom: 18,
        attribution: ''
    });

    var latlng = L.latLng('-7.6145', '110.7122');

    var map = L.map('map', {
        center: latlng,
        zoom: 7,
        layers: [tiles]
    });

    var markers = L.markerClusterGroup();

    var addressPoints = [
        <?php $__currentLoopData = $kegiatan; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $a): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            ['<?php echo e($a->latitude); ?>', '<?php echo e($a->longitude); ?>', "<?php echo e($a->nama_kegiatan); ?>"],
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    ];

    // addressPoints.forEach(function(point) {
    //     var marker = L.marker(L.latLng(point[0], point[1]))
    //         .bindPopup(point[2]);
    //     markers.addLayer(marker);
    // });

    console.log(addressPoints);

    for (var i = 0; i < addressPoints.length; i++) {

        var a = addressPoints[i];

        var title = a[2];

        var marker = L.marker(new L.LatLng(a[0], a[1]), {

            title: title

        });

        marker.bindPopup(title);

        markers.addLayer(marker);

    }

    map.addLayer(markers);

    document.getElementById('id_lokasi').addEventListener('change', function(e) {
        var selectedOption = e.target.options[e.target.selectedIndex];
        var lat = selectedOption.getAttribute('data-lat');
        var lng = selectedOption.getAttribute('data-lng');

        if (lat && lng) {
            map.setView([lat, lng], 13);
        }
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home3/baktijay/public_html/bkn-web/resources/views/laporan/lokasi_kegiatan/index.blade.php ENDPATH**/ ?>