<?php $__env->startSection('title','Lokasi'); ?>
<?php $__env->startSection('css'); ?>
<link rel="stylesheet" href="https://unpkg.com/leaflet@1.0.3/dist/leaflet.css" integrity="sha512-07I2e+7D8p6he1SIM+1twR5TIrhUQn9+I6yjqD53JQjFiMf8EtC93ty0/5vJTZGF8aAocvHYNEDJajGdNx1IsQ==" crossorigin="" />

<script src="https://unpkg.com/leaflet@1.0.3/dist/leaflet-src.js" integrity="sha512-WXoSHqw/t26DszhdMhOXOkI7qCiv5QWXhH9R7CgvgZMHz1ImlkVQ3uNsiQKu5wwbbxtPzFXd1hK4tzno2VqhpA==" crossorigin=""></script>

<link rel="stylesheet" href="<?php echo e(asset('assets/css/maps/screen.css')); ?>">

<link rel="stylesheet" href="<?php echo e(asset('assets/css/maps/MarkerCluster.css')); ?>">

<link rel="stylesheet" href="<?php echo e(asset('assets/css/maps/MarkerCluster.Default.css')); ?>">

<link rel="stylesheet" href="<?php echo e(asset('assets/js/maps/leaflet.markercluster-src.js')); ?>">
<style>

    #map {
        width: 100%;
        height: 500px;
        border: 1px solid #ccc;
    }

    /* .card-body {
        height: 800px;
    }

    .card-body #map {
        position: absolute;
        top: 0;
        bottom: 0;
        left: 0;
        right: 0;
    } */

</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>  
  <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Lokasi</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Lokasi</a></li>
              <li class="breadcrumb-item active">Create</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-12">
            <div class="card card-primary"> 
                <form action="<?php echo e(route('lokasi.store')); ?>" method="post" enctype="multipart/form-data">
                    <div class="card-body">
                        <?php echo csrf_field(); ?>
                        
                        
                        
                        <div class="form-group row">
                            <label for="file" class="col-sm-2 col-form-label">Provinsi</label>
                            <div class="col-sm-5">
                                <select name="id_provinsi" id="id_provinsi" onchange="provinsiFunction(this.value)" class="form-control" required>
                                    <option value=""></option>
                                    <?php $__currentLoopData = $provinsi; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($value->id_provinsi); ?>"><?php echo e($value->nama_provinsi); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="file" class="col-sm-2 col-form-label">Kabupaten Kota</label>
                            <div class="col-sm-5">
                                <select name="id_kabupaten_kota" id="id_kabupaten_kota" class="form-control" required>
                                    <option value=""></option>
                                </select>
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="file" class="col-sm-2 col-form-label">Detail Lokasi</label>
                            <div class="col-sm-10">
                                <input type="text" name="detail_lokasi" id="detail_lokasi" class="form-control">
                            </div>
                        </div>

                        
                        <div>
                            <center>Klik lokasi pada map untuk menentukan lokasi Kegiatan</center>
                            <div id="map"></div>
                            <br/>
                        </div>
                       
                        

                        <div class="form-group row">
                            <label for="file" class="col-sm-2 col-form-label">Longitude</label>
                            <div class="col-sm-4">
                                <input type="text" name="longitude" id="longitude" class="form-control" readonly required>
                            </div>

                            <label for="file" class="col-sm-2 col-form-label">Latitude</label>
                            <div class="col-sm-4">
                                <input type="text" name="latitude" id="latitude" class="form-control" readonly required>
                            </div>
                        </div>

                    
                        <div class="form-group row">
                            <label for="file" class="col-sm-2 col-form-label">Dokumen</label>
                            <div class="col-sm-4">
                                <input type="file" name="image" id="image" class="form-control" id="file">
                                <div class="alertSize" style="display: none;">File anda melebihi 5 MB</div>
                                <div class="alert" style="display: none;">File anda Bukan gambar, tidak dapat diupload</div>
                            </div>
                        </div>
                        
                    </div>
                    <div class="card-footer">
                        <button id="btnSave" type="submit" class="btn btn-info">Simpan</button>
                        <a href="<?php echo e(route('lokasi.index')); ?>" class="btn btn-default">Batal</a>
                    </div>
                </form>
            </div>
          </div>
          
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- /.content -->
  <?php $__env->stopSection(); ?>
  <?php $__env->startSection('js'); ?>
    <script>
        function provinsiFunction(value) {
            $.ajax({
                method: 'POST',
                url: '<?php echo e(url("get-provinsi")); ?>',
                data:{
                        _token: '<?php echo e(csrf_token()); ?>', 
                        id_provinsi: $('#id_provinsi').find(":selected").val(),
                },
                success: function(data) {
                    //console.log(data);
                    $("#id_kabupaten_kota").html(data);
                }

            });
        }

        var tiles = L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {

            maxZoom: 18,

            attribution: ''

        }),

        latlng = L.latLng('-7.6145', '110.7122');

        var map = L.map('map', {

            center: latlng,

            zoom: '8',

            layers: [tiles]

        });

        var markers = null;
        map.on('click', function(e) {

          if (markers !== null) {

              map.removeLayer(markers);

          }



          //e.removeLayer();

          document.getElementsByName("latitude")[0].value = e.latlng.lat;

          document.getElementsByName("longitude")[0].value = e.latlng.lng;

          //var kodeBarang = document.getElementById("kode_barang");

          //var title = kodeBarang.options[kodeBarang.selectedIndex].text;



          markers = L.marker(e.latlng).addTo(map);





        });
    </script>
  <?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home3/baktijay/public_html/bkn-web/resources/views/pengaturan/lokasi/create.blade.php ENDPATH**/ ?>