<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Katalog;

class KatalogController extends Controller
{
    public function index()
    {
        $data = Katalog::all();
        //dd($sejarah);
        return view('katalog.index', compact('data'));
    }

    public function create()
    {

        //dd($sejarah);
        return view('katalog.create');
    }

    public function edit($id)
    {
        $katalog = Katalog::findOrFail($id);
        //dd($sejarah);
        return view('katalog.edit', compact('katalog'));
    }

    public function store(Request $request)
    {
        $image = $request->file('image');
        $nama_image = 'katalog-' . uniqid() . '-' . $image->getClientOriginalName();
        $dir = 'img/katalog';
        $image->move(public_path($dir), $nama_image);
        $storeData = [
            'nama_katalog' => $request->input('nama_katalog'),
            'katalog' => $nama_image,

        ];
        Katalog::create($storeData);
        //Contact::where('id', $id)->update($request->except(['_token', '_method']));
        return redirect('katalog')->with('alert-success', 'Success Update Data');
    }


    public function update(Request $request, $id)
    {
        $image = $request->file('image');
        $nama_image = 'katalog-' . uniqid() . '-' . $image->getClientOriginalName();
        $dir = 'img/katalog';
        $image->move(public_path($dir), $nama_image);
        $updateDate = [
            'nama_katalog' => $request->input('nama_katalog'),
            'katalog' => $nama_image,

        ];
        Katalog::where('id', $id)->update($updateDate);
        //Contact::where('id', $id)->update($request->except(['_token', '_method']));
        return redirect('katalog')->with('alert-success', 'Success Update Data');
    }

    public function destroy($id)
    {
        Katalog::findOrFail($id)->delete();
        return redirect('katalog')->with('alert-success', 'Success deleted data');
    }
}
