
<?php $__env->startSection('title','Absensi'); ?>
<?php $__env->startSection('css'); ?>
<style>
#cameraPreview:hover {
    border-color: #0d6efd;
    transform: scale(1.02);
}
#cameraPreview:hover #cameraIcon {
    opacity: 1;
    transform: scale(1.1);
}
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

        <div class="page-content-wrapper py-3">
			<div class="container">
				<!-- Contact Form -->
				<div class="card mb-3">
					<div class="card-body">
						
						<div class="contact-form">
							<form id="absenForm" action="<?php echo e(route('absen.store')); ?>" method="post" enctype="multipart/form-data" class="text-center">
                                <?php echo csrf_field(); ?>
                                
                                <input type="hidden" name="latitude">
                                <input type="hidden" name="longitude">
                                
                                
                                <div class="mb-4">
                                    <!-- Camera Preview Area -->
                                    <div id="cameraPreview" class="mx-auto mb-3" style="width: 250px; height: 250px; border: 2px dashed #ddd; display: flex; align-items: center; justify-content: center; cursor: pointer;">
                                        <img id="cameraIcon" src="<?php echo e(asset('img/camera-icon.jpg')); ?>" class="img-fluid" style="max-width: 80px; opacity: 0.7; transition: all 0.3s ease;">
                                    </div>
                                    
                                    <!-- Actual File Input (hidden) -->
                                    <input type="file" id="selfieInput" name="image" accept="image/*" capture="user" style="display: none;">
                                    
                                    <div class="text-muted">
                                        <h5 class="mb-1">Ambil Selfie</h5>
                                        <small>Klik pada area kamera di atas</small>
                                    </div>
                                </div>
                                
                                <button type="submit" class="btn btn-primary w-100 py-2" style="border-radius: 25px;">
                                    <i class="fa fa-save me-2"></i> Simpan Absensi
                                </button>
                            </form>
						</div>
					</div>
				</div>
			</div>
		</div>
<?php $__env->startSection('js'); ?>
<script>
 document.addEventListener('DOMContentLoaded', function() {
    const cameraPreview = document.getElementById('cameraPreview');
    const selfieInput = document.getElementById('selfieInput');
    const cameraIcon = document.getElementById('cameraIcon');
    
    // Handle click on preview area
    cameraPreview.addEventListener('click', function() {
        selfieInput.click();
    });
    
    // Handle file selection
    selfieInput.addEventListener('change', function(e) {
        if (e.target.files && e.target.files[0]) {
            const reader = new FileReader();
            
            reader.onload = function(event) {
                cameraPreview.style.backgroundImage = `url(${event.target.result})`;
                cameraPreview.style.backgroundSize = 'cover';
                cameraPreview.style.backgroundPosition = 'center';
                cameraIcon.style.opacity = '0';
            }
            
            reader.readAsDataURL(e.target.files[0]);
        }
    });
    
    // Get geolocation
    if (navigator.geolocation) {
        navigator.geolocation.getCurrentPosition(function(position) {
            document.querySelector('input[name="latitude"]').value = position.coords.latitude;
            document.querySelector('input[name="longitude"]').value = position.coords.longitude;
            
            // Reverse geocoding would go here (using Map API)
        });
    }
});
</script>
<?php $__env->stopSection(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home3/baktijay/public_html/ptgib.co.id/admin_pwa/resources/views/absen/create.blade.php ENDPATH**/ ?>