<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="theme-color" content="#0134d4">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black">

    <title>.:: PT. GIB ::.</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&amp;display=swap" rel="stylesheet">
    <!------------------- Favicon ---------------------->
    <link rel="icon" href="<?php echo e(asset('img/core-img/favicon.ico')); ?>">
    <link rel="apple-touch-icon" href="<?php echo e(asset('img/icons/icon-96x96.png')); ?>">
    <link rel="apple-touch-icon" sizes="152x152" href="<?php echo e(asset('img/icons/icon-152x152.png')); ?>">
    <link rel="apple-touch-icon" sizes="167x167" href="<?php echo e(asset('img/icons/icon-167x167.png')); ?>">
    <link rel="apple-touch-icon" sizes="180x180" href="<?php echo e(asset('img/icons/icon-180x180.png')); ?>">
    <!--------------------------------------------->
    <!-- CSS Libraries-->
    <link rel="stylesheet" href="<?php echo e(asset('/msg/css/bootstrap.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('/msg/css/animate.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('/msg/css/owl.carousel.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('/msg/css/font-awesome.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('/msg/css/lineicons.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('/msg/css/magnific-popup.css')); ?>">
    <!-- Stylesheet-->
    <link rel="stylesheet" href="<?php echo e(asset('/msg/css/style.css')); ?>">
    <!-- Web App Manifest-->
    <link rel="manifest" href="<?php echo e(url('manifest.json')); ?>">
    
  </head>
  <body>
    <!-- Preloader-->
    <div class="preloader" id="preloader">
      <div class="spinner-grow text-secondary" role="status">
        <div class="sr-only">Loading...</div>
      </div>
    </div>
    <!-- Internet Connection Status-->
    <div class="internet-connection-status" id="internetStatus"></div>
    <!-- Header Area-->
    <div class="header-area" id="headerArea">
      <div class="container h-100 d-flex align-items-center justify-content-between">
        <!-- Back Button-->
        <div class="back-button"><a href="<?php echo e(route('komplain.index')); ?>">
            <svg class="bi bi-arrow-left" xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" viewBox="0 0 16 16">
              <path fill-rule="evenodd" d="M15 8a.5.5 0 0 0-.5-.5H2.707l3.147-3.146a.5.5 0 1 0-.708-.708l-4 4a.5.5 0 0 0 0 .708l4 4a.5.5 0 0 0 .708-.708L2.707 8.5H14.5A.5.5 0 0 0 15 8z"></path>
            </svg></a></div>
        <!-- Page Title-->
        <div class="page-heading">
          <h6 class="mb-0">Komplain</h6>
        </div>
        <!-- Navbar Toggler-->
        <div class="suha-navbar-toggler" data-bs-toggle="offcanvas" data-bs-target="#suhaOffcanvas" aria-controls="suhaOffcanvas">
            
        </div>
      </div>
    </div>
    
    <div class="page-content-wrapper">
        <!-- Live Chat Intro-->
      <div class="live-chat-intro mb-3" style="color: white">
        <?php echo e($kunjungan->nama_customer); ?>

        <br/>
        <?php echo e($kunjungan->alamat); ?>

        <br/>
        <?php echo e($kunjungan->no_telp); ?>

      </div>
      <!-- Support Wrapper-->
     
      <div class="support-wrapper py-3">
        <div class="container">
          <!-- Live Chat Wrapper-->
          <div class="live-chat-wrapper" id="chat-box">
            <!-- Agent Message Content-->
            <div class="agent-message-content d-flex align-items-start">
              <!-- Agent Thumbnail-->
              
              <!-- Agent Message Text-->
              <div class="agent-message-text">
                <div class="d-block">
                  <p>
                    <?php echo e($kunjungan->pesan); ?>

                    <?php if($kunjungan->gambar): ?>
                      <a href="<?php echo e(asset('img/komplain/'.$kunjungan->gambar)); ?>" target="_blank" rel="noopener noreferrer">
                        <img src="<?php echo e(asset('img/1375106.png')); ?>" style="width: 5%" alt="Camera Icon">
                      </a>
                    <?php endif; ?>
                  </p>
                 
                </div>
                <span><?php echo e($kunjungan->nama_lengkap.' '.TanggalHelper::get_date_time($kunjungan->created_at)); ?></span>
              </div>
            </div>
            <?php $__currentLoopData = $koordinasi; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            
                <!-- User Message Content-->
                <div class="<?php echo e(Auth::user()->id == $item['id_user'] ?'user-message-content':'agent-message-content d-flex align-items-start'); ?>">
                    <!-- User Message Text-->
                    <div class="<?php echo e(Auth::user()->id == $item['id_user'] ?'user':'agent'); ?>-message-text">
                        <div class="d-block">
                            <p>
                                <?php if($item->hapus): ?>
                                   <i>--Dihapus--</i> 
                                <?php else: ?>
                                    <?php echo e($item['catatan']); ?>

                                <?php endif; ?>
                               
                                
                            </p>
                            <span>
                                <?php if(Auth::user()->id != $item['id_user']): ?>
                                    <?php echo e($item->nama_lengkap); ?>

                                <?php endif; ?>
                                <?php echo e(TanggalHelper::get_date_time($item['created_at'])); ?>

                                <?php if(Auth::user()->id == $item['id_user']): ?>
                                    <?php if($item->hapus): ?>
                                    <?php else: ?>
                                        <?php if($kunjungan->sts ==0): ?>
                                            <form method="POST" action="<?php echo e(route('komplain.update', ['komplain' => $kunjungan->id])); ?>">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('PUT'); ?>
                                                <input type="hidden" name="id_chat" value="<?php echo e($item['id']); ?>">
                                                <input type="hidden" name="delete" value="ok">
                                                <button type="submit" class="btn-sm btn-danger"><i class="fa fa-trash-o"></i></button>
                                            </form>
                                        <?php endif; ?>   
                                    <?php endif; ?>
                                <?php endif; ?>
                            </span>
                        </div>
                        
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php if($kunjungan->sts ==0): ?>
                <!-- Checkbox Tambahan -->
                <div class="form-check mt-2" style="float: right;">
                    <form method="POST" action="<?php echo e(route('komplain.update', ['komplain' => $kunjungan->id])); ?>">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>
                        
                        <input type="hidden" name="update_sts" value="ok">
                        <button onclick="return confirm('Yakin ingin menyelesaikan komplain ini?')" type="submit" class="btn-sm btn-success"><i class="fa fa-check"></i> Selesai</button>
                    </form>
                </div>
                <br/>
            <?php endif; ?>
            
            
          </div>
        </div>
      </div>
    </div>
    <?php if($kunjungan->sts ==0): ?>
        <!-- Type Message Form-->
        <div class="type-text-form">

        <form action="<?php echo e(route('komplain.update', ['komplain' => $kunjungan->id])); ?>" method="post" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>
            <div class="form-group file-upload mb-0">
            <input type="file"><i class="lni lni-plus"></i>
            
            </div>
            
            <textarea class="form-control" name="message" cols="30" rows="10" placeholder="Type your message" required></textarea>
            
            <button type="submit">
            <svg class="bi bi-arrow-right" xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" viewBox="0 0 16 16">
                <path fill-rule="evenodd" d="M1 8a.5.5 0 0 1 .5-.5h11.793l-3.147-3.146a.5.5 0 0 1 .708-.708l4 4a.5.5 0 0 1 0 .708l-4 4a.5.5 0 0 1-.708-.708L13.293 8.5H1.5A.5.5 0 0 1 1 8z"></path>
            </svg>
            </button>
        </form>
        </div>
    <?php else: ?>
    
        <h5 style="text-align: center"><i style="color:green;" class="fa fa-check">Komplain Telah Selesai</i></h5>
    <?php endif; ?>
    <!-- All JavaScript Files-->
    <script src="<?php echo e(asset('/msg/js/bootstrap.bundle.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/msg/js/jquery.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/msg/js/waypoints.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/msg/js/jquery.easing.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/msg/js/owl.carousel.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/msg/js/jquery.magnific-popup.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/msg/js/jquery.counterup.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/msg/js/jquery.countdown.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/msg/js/jquery.passwordstrength.js')); ?>"></script>
    <script src="<?php echo e(asset('/msg/js/dark-mode-switch.js')); ?>"></script>
    <script src="<?php echo e(asset('/msg/js/no-internet.js')); ?>"></script>
    <script src="<?php echo e(asset('/msg/js/active.js')); ?>"></script>
    <script src="<?php echo e(url('upup.min.js')); ?>"></script>
    <script>
        UpUp.start({
            'cache-version': 'v2',
            'content-url': 'https://app.ptgib.co.id/',

            'content': 'Cannot reach site. Please check your internet connection.',
            'service-worker-url': 'https://app.ptgib.co.id/upup.sw.min.js'
        });

       document.addEventListener("DOMContentLoaded", function () {
            setTimeout(function () {
                window.scrollTo(0, document.body.scrollHeight);
            }, 100);
        });
    </script>
  </body>
</html><?php /**PATH /home3/baktijay/public_html/ptgib.co.id/admin_pwa/resources/views/komplain/edit.blade.php ENDPATH**/ ?>