<?php

namespace App\Http\Controllers;


use App\Models\MasterLocations;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use Yajra\DataTables\Facades\DataTables;
use Illuminate\Support\Facades\File;

class LocationController extends Controller
{
    public function index()
    {
        return view('master.locations.index');
    }

    public function create()
    {


        return view('master.locations.create');
    }

    public function edit($id)
    {

        $data = MasterLocations::findOrFail($id);

        return view('master.locations.edit', compact('data'));
    }





    public function store(Request $request)
    {
        // Ambil data text
        $data = [
            'name'     => $request->name,
            'description' => $request->description
        ];



        MasterLocations::create($data);

        return redirect()
            ->route('location.index')
            ->with('alert-success', 'Data  berhasil disimpan.');
    }

    public function update(Request $request, MasterLocations $location)
    {
        // Update field teks
        $data = [
            'name'     => $request->name,
            'description' => $request->description
        ];



        $location->update($data);

        return redirect()
            ->route('location.index')
            ->with('alert-success', 'Data  berhasil diupdate.');
    }


    public function destroy(MasterLocations $location)
    {


        $location->delete();

        return redirect()
            ->route('location.index')
            ->with('alert-success', 'Data  berhasil dihapus.');
    }

    public function getData(Request $request)
    {
        if ($request->ajax()) {
            $data = MasterLocations::select('master_locations.*')
                ->orderBy('master_locations.id', 'desc')
                ->get();

            return Datatables::of($data)
                // Kolom ACTION (sudah punya)
                ->addColumn('action', function ($row) {
                    $editRoute   = route('location.edit', ['location' => $row->id]);
                    $deleteRoute = route('location.destroy', ['location' => $row->id]);

                    $btn  = '<form method="POST" action="' . $deleteRoute . '" style="margin-left: 10px;" onsubmit="return confirm(\'Apakah anda yakin?\')">';
                    $btn .= '<div class="btn-group">';
                    $btn .= '<a href="' . $editRoute . '" class="btn btn-warning">Edit</a>';
                    $btn .= '<button type="submit" class="btn btn-danger ml-2">Hapus</button>';
                    $btn .= csrf_field();
                    $btn .= method_field("DELETE");
                    $btn .= '</div>';
                    $btn .= '</form>';

                    return $btn;
                })
                ->rawColumns(['action'])
                ->make(true);;
        }
    }

    public function apiIndex()
    {
        $data = MasterLocations::orderBy('no', 'asc')
            ->get()
            ->map(function ($item) {
                return [
                    'id'        => $item->id,
                    'name'        => $item->name,
                    'description'    => $item->description,
                    'created_at' => $item->created_at,
                    'updated_at' => $item->updated_at,
                ];
            });

        return response()->json([
            'status'  => true,
            'message' => 'List Locations',
            'data'    => $data,
        ]);
    }
}
